(() => {
  // 二重読み込み防止
  // 旧実装や別プラグインと衝突しないよう、名前空間を切る
  window.__CAF_INIT__ = window.__CAF_INIT__ || {};
  if (window.__CAF_INIT__.categoryAjaxFetch) return;
  window.__CAF_INIT__.categoryAjaxFetch = true;

  const onReady = (fn) => {
    if (document.readyState === "loading") {
      document.addEventListener("DOMContentLoaded", fn, { once: true });
    } else {
      fn();
    }
  };

  const postForm = async (url, data) => {
    const body = new URLSearchParams();
    for (const k in data) body.append(k, data[k]);

    const res = await fetch(url, {
      method: "POST",
      headers: { "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8" },
      body: body.toString(),
      credentials: "same-origin",
    });

    const json = await res.json().catch(() => null);
    return { ok: res.ok, status: res.status, json };
  };

  // 下層radio解除
  const clearCheckBelow = (labelElem) => {
    const base = labelElem.closest("[depth]");
    if (!base) return;

    const depth = base.getAttribute("depth");
    const checked = document.querySelectorAll(
      `[category_explorer_container] [depth="${depth}"] ~ [depth] input[type="radio"]:checked`
    );
    checked.forEach((r) => (r.checked = false));
  };

  // ラジオ再タップで解除（iOS対策込み）
  const enableRadioToggle = () => {
    const markWasChecked = (e) => {
      const label = e.target.closest("label");
      if (!label) return;
      const input = label.querySelector("input[category_selector]");
      if (!input) return;
      input.dataset.wasChecked = input.checked ? "1" : "0";
    };

    const toggleIfReclicked = (e) => {
      const label = e.target.closest("label");
      if (!label) return;
      const input = label.querySelector("input[category_selector]");
      if (!input) return;

      if (input.dataset.wasChecked === "1") {
        e.preventDefault();
        e.stopPropagation();
        input.checked = false;
        clearCheckBelow(label);
      }

      delete input.dataset.wasChecked;
    };

    document.addEventListener("pointerdown", markWasChecked, true);
    document.addEventListener("touchstart", markWasChecked, true);
    document.addEventListener("mousedown", markWasChecked, true);
    document.addEventListener("click", toggleIfReclicked, true);

    // 通常選択時も下層を畳む（インラインonclick不要化）
    document.addEventListener(
      "change",
      (e) => {
        const input = e.target && e.target.matches && e.target.matches("input[category_selector]")
          ? e.target
          : null;
        if (!input) return;
        const label = input.closest("label");
        if (!label) return;
        clearCheckBelow(label);
      },
      true
    );
  };

  const createCategoryLink = (data, parent, depth) => {
    const container = document.createElement("div");
    container.setAttribute("parent", parent);

    container.innerHTML =
      `<div class="category"><label>` +
      `<input type="radio" category_selector name="category_selector${depth}" value="${data.slug}">` +
      `${data.name}</label></div>` +
      `<style>` +
      `[category_explorer_container]:has([category_selector][value="${data.slug}"]:not(:checked)) ` +
      `[parent="${data.slug}"]{display:none;}` +
      `</style>`;

    container.dataset.slug = data.slug;
    return container;
  };

const createPostsLink = (data, parent) => {
  const container = document.createElement("div");
  container.setAttribute("parent", parent);

  const thumb = data.thumbnail ? `<img src="${data.thumbnail}" alt="">` : "";

  container.innerHTML =
    `<div class="post">` +
    `<a href="${data.url}">` +
    thumb +
    `<span class="title">${data.title}</span>` +
    `</a></div>`;

  return container;
};


  // depthコンテナ（div[depth="n"]）を確実に用意して返す
  const ensureDepthContainers = (explorer, depth) => {
    let cur = explorer.querySelector(`div[depth="${depth}"]`);
    if (!cur) {
      cur = document.createElement("div");
      cur.setAttribute("depth", String(depth));
      explorer.appendChild(cur);
    }

    let next = explorer.querySelector(`div[depth="${depth + 1}"]`);
    if (!next) {
      next = document.createElement("div");
      next.setAttribute("depth", String(depth + 1));
      explorer.appendChild(next);
    }

    return { cur, next };
  };

  const create_category_exploler_container = (my_data, depth, parent) => {
    const explorer = document.querySelector("[category_explorer_container]");
    if (!explorer) return;

    const { cur, next } = ensureDepthContainers(explorer, depth);

    for (let i = 0; i < my_data.length; i++) {
      cur.appendChild(createCategoryLink(my_data[i], parent, depth));

      if (my_data[i].children && my_data[i].children.length) {
        create_category_exploler_container(my_data[i].children, depth + 1, my_data[i].slug);
      }

      if (my_data[i].posts && my_data[i].posts.length) {
        for (let j = 0; j < my_data[i].posts.length; j++) {
          next.appendChild(createPostsLink(my_data[i].posts[j], my_data[i].slug));
        }
      }
    }
  };
  
  
  

  onReady(async () => {
    // ショートコードのid指定や、テーマ側の差し替えに強くする
    const anchor =
      document.querySelector("[data-caf-anchor]") ||
      document.querySelector("#wp-column-directory-anchor");
    if (!anchor) return;

    // 既存コンテナがあれば削除（再描画/二重実行保険）
    const old = document.querySelector("[category_explorer_container]");
    if (old) old.remove();

    // コンテナを先に挿入（AJAXより先）
    const explorer = document.createElement("div");
    explorer.setAttribute("category_explorer_container", "1");
    explorer.setAttribute("id", "wp-column-directory");
    explorer.setAttribute("class", "wp-column-directory");
    anchor.parentNode.insertBefore(explorer, anchor);

    enableRadioToggle();

if (!window.categoryAjax || !window.categoryAjax.ajax_url) {
  console.log("CAF: categoryAjax.ajax_url not found");
  return;
}

const { ok, status, json } = await postForm(window.categoryAjax.ajax_url, {
  action: "fetch_categories",
  nonce: window.categoryAjax.nonce
});

const isMobile = window.matchMedia("(max-width: 768px)").matches;
console.log("CAF isMobile:", isMobile, "width:", window.innerWidth);

// 失敗なら抜ける（まず安全に）
if (!ok || !json || !json.success || !Array.isArray(json.data)) {
  console.log("CAF: ajax returned error", status, json);
  return;
}

// スマホはドリルダウンUIに切替（既存ツリーは使わない）
if (isMobile) {
  enableDrilldownUI(explorer, json.data); // ← explorer に描画
  return; // ← これが超重要：下のcreate_category...を止める
}

// ===== ドリルダウン（スマホ） =====
function enableDrilldownUI(containerEl, rootCategories) {
  // 仮想ルートノード
  const rootNode = { term_id: 0, name: "", children: rootCategories, posts: [] };

  // 現在位置（ノードのスタック）
  const path = [rootNode];

  // UI骨格
  containerEl.innerHTML = `
    <div class="caf-drill-header" role="navigation" aria-label="Category navigation">
      <button type="button" class="caf-back" disabled>‹</button>
      <div class="caf-crumb" aria-label="Breadcrumb"></div>
    </div>
    <div class="caf-drill-body">
      <div class="caf-cat-list"></div>
      <div class="caf-post-list"></div>
    </div>
  `;

  const backBtn = containerEl.querySelector(".caf-back");
  const crumbEl = containerEl.querySelector(".caf-crumb");
  const catListEl = containerEl.querySelector(".caf-cat-list");
  const postListEl = containerEl.querySelector(".caf-post-list");

  function renderCrumb() {
    // 例: カテゴリ > WEB関連 > Wordpress
    const names = path.map(n => n.name).filter(Boolean);
    crumbEl.textContent = names.join(" > ");
  }

function render(node) {
  const atRoot = path.length <= 1;

  // ルートでは「戻る」を隠す（または表示するなら disabled）
  backBtn.style.display = atRoot ? "none" : "";
  backBtn.disabled = atRoot;

  renderCrumb();

    // カテゴリ一覧（この階層だけ表示）
    catListEl.innerHTML = "";
    const children = Array.isArray(node.children) ? node.children : [];
    if (children.length) {
      const ul = document.createElement("ul");
      ul.className = "caf-list";
      children.forEach(child => {
        const li = document.createElement("li");
        li.className = "caf-item caf-item-cat";
        li.dataset.termId = String(child.term_id);
        li.innerHTML = `
          <button type="button" class="caf-cat-btn">
            <span class="caf-cat-name">${escapeHtml(child.name)}</span>
            <span class="caf-cat-meta">${child.children?.length ? "›" : ""}</span>
          </button>
        `;
        ul.appendChild(li);
      });
      catListEl.appendChild(ul);
    }

    // 記事一覧（そのカテゴリ直下の posts を表示）
    postListEl.innerHTML = "";
    const posts = Array.isArray(node.posts) ? node.posts : [];
    if (posts.length) {
      const ul = document.createElement("ul");
      ul.className = "caf-posts";
      posts.forEach(p => {
        const li = document.createElement("li");
        li.className = "caf-post";
        const thumb = p.thumbnail ? `<img class="caf-thumb" src="${escapeAttr(p.thumbnail)}" alt="">` : "";
        li.innerHTML = `
          <a class="caf-post-link" href="${escapeAttr(p.url)}">
            ${thumb}
            <span class="caf-post-title">${escapeHtml(p.title)}</span>
          </a>
        `;
        ul.appendChild(li);
      });
      postListEl.appendChild(ul);
    } else {
      // 空でもOK（必要なら消してもいい）
      postListEl.innerHTML = ``;
    }
  }

  function escapeHtml(str) {
    return String(str ?? "")
      .replaceAll("&", "&amp;")
      .replaceAll("<", "&lt;")
      .replaceAll(">", "&gt;")
      .replaceAll('"', "&quot;")
      .replaceAll("'", "&#039;");
  }
  function escapeAttr(str) {
    // 属性用（最低限）
    return escapeHtml(str);
  }

  function findChildById(node, termId) {
    const children = node.children || [];
    return children.find(c => String(c.term_id) === String(termId));
  }

  // クリック（イベント委任）
  containerEl.addEventListener("click", (e) => {
    const back = e.target.closest(".caf-back");
    if (back) {
      if (path.length > 1) path.pop();
      render(path[path.length - 1]);
      return;
    }

    const catBtn = e.target.closest(".caf-item-cat");
    if (catBtn) {
      const termId = catBtn.dataset.termId;
      const current = path[path.length - 1];
      const next = findChildById(current, termId);
      if (!next) return;

      // ドリルダウン：次の階層へ（他カテゴリは描画しないので消える）
      path.push(next);
      render(next);
      return;
    }
  });

  // 初期描画
  render(rootNode);
}


console.log(json);

    if (!ok) {
      console.log("CAF: ajax http error", status, json);
      return;
    }

    if (json && json.success) {
      create_category_exploler_container(json.data, 0, "root");
    } else {
      console.log("CAF: ajax returned error", json);
    }
  });
})();