<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// 管理画面のツールメニュー直下に「カラムカテゴリー設定」を追加
function caf_add_admin_submenu() {
    add_submenu_page(
        'tools.php',             // 親メニュー: tools.php
        'RCNカテゴリー設定',      // サブメニューのページタイトル
        'RCNカテゴリー設定',      // サブメニュー名
        'manage_options',        // 権限
        'caf_settings',// スラッグ
        'caf_render_settings_page' // コールバック関数
    );
}
add_action('admin_menu', 'caf_add_admin_submenu');

// 設定ページの内容をレンダリング
function caf_render_settings_page() {
    ?>
    <div class="wrap">
        <h1>RCNカテゴリー設定</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('caf_settings_group');
            do_settings_sections('caf_exclude_categories');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// 設定フィールドの登録
function caf_register_settings() {
			
	// ショートコード表示用セクションの追加
		register_setting('caf_settings_group', 'caf_shortcode_display');
		add_settings_section(
			'caf_shortcode_display_section',
			'ショートコード',
			'caf_shortcode_display_section_callback',
			'caf_exclude_categories'
		);

    // 1.開始カテゴリーを選択
		register_setting('caf_settings_group', 'caf_start_category');
		add_settings_section(
			'caf_start_category_section',
			'1.開始カテゴリーを選択',
			'caf_start_category_section_callback',
			'caf_exclude_categories'
		);
		add_settings_field(
			'caf_start_category_field',
			'開始カテゴリー',
			'caf_render_start_category_field',
			'caf_exclude_categories',
			'caf_start_category_section'
		);
	
    // 2.除外カテゴリーを選択
		register_setting('caf_settings_group', 'caf_exclude_categories');
		add_settings_section(
			'caf_settings_section',
			'2.除外カテゴリーを選択',
			'caf_settings_section_callback',
			'caf_exclude_categories'
		);
		add_settings_field(
			'caf_exclude_categories_field',
			'カテゴリ一覧',
			'caf_render_categories_field',
			'caf_exclude_categories',
			'caf_settings_section'
		);
	
	// 3.カラム幅設定
		register_setting('caf_settings_group', 'caf_column_width');
		add_settings_section(
			'caf_column_width_section',
			'3.カラム幅(開発中)',
			'caf_column_width_section_callback',
			'caf_exclude_categories'
		);
		add_settings_field(
			'caf_column_width_field',
			'カラム幅を選択(開発中)',
			'caf_render_column_width_field',
			'caf_exclude_categories',
			'caf_column_width_section'
		);

	// 4.アイコン設定
		register_setting('caf_settings_group', 'caf_icon');
		add_settings_section(
			'caf_icon_section',
			'4.アイコンの選択(開発中)',
			'caf_icon_section_callback',
			'caf_exclude_categories'
		);
		add_settings_field(
			'caf_icon_field',
			'アイコンの種類',
			'caf_render_icon_field',
			'caf_exclude_categories',
			'caf_icon_section'
		);

	// 5.アイキャッチ画像設定
		register_setting('caf_settings_group', 'caf_thumb');
		add_settings_section(
			'caf_thumb_section',
			'5.アイキャッチ画像設定(開発中)',
			'caf_thumb_section_callback',
			'caf_exclude_categories'
		);
		add_settings_field(
			'caf_thumb_field',
			'アスペクト比率',
			'caf_render_thumb_field',
			'caf_exclude_categories',
			'caf_thumb_section'
		);

}

function caf_shortcode_display_section_callback() {
    echo '<p>以下のショートコードを使用して、任意の場所にカラムカテゴリーを出力できます。</p>';
    echo '<pre style="background-color: #ccc; padding:6px 8px;border-radius: 4px;display:inline-block;">[rcn_view]</pre>';
    echo '<p>PHPに直接追加する場合:</p>';
    echo '<pre style="background-color: #ccc; padding:6px  8px;border-radius: 4px;display:inline-block;">&lt;?php echo do_shortcode(\'[rcn_view]\'); ?&gt;</pre>';
    echo '<p>必要に応じて、下記の設定からカスタマイズできます。設定を反映するには最後の[変更を保存]を押してください。</p>';
}

add_action('admin_init', 'caf_register_settings');



// セクションの説明を表示
function caf_settings_section_callback() {
    echo '<p>除外したいカテゴリーにチェックを入れて保存してください。(複数選択可)</p>';
}

// 開始カテゴリーセクションの説明を表示
function caf_start_category_section_callback() {
    echo '<p>開始カテゴリーを選択してください。指定したカテゴリー直下が1カラム目となります。</p>';
}

// 除外カテゴリをチェックボックスで表示（親子関係を示す）
function caf_render_categories_field() {
    $categories = get_categories(array('hide_empty' => false, 'parent' => 0));
    $selected_categories = get_option('caf_exclude_categories', array());

    function display_category_with_children($parent_id = 0, $selected_categories) {
        $categories = get_categories(array('hide_empty' => false, 'parent' => $parent_id));
        foreach ($categories as $category) {
            $checked = in_array($category->term_id, (array) $selected_categories) ? 'checked' : '';
            echo '<label style="margin-left: ' . ($parent_id ? '20px' : '0') . ';">';
            echo '<input type="checkbox" name="caf_exclude_categories[]" value="' . esc_attr($category->term_id) . '" ' . $checked . '>';
            echo esc_html($category->name);
            echo '</label><br>';
            display_category_with_children($category->term_id, $selected_categories);
        }
    }

    display_category_with_children(0, $selected_categories);
}

// 開始カテゴリーをラジオボタンで表示（親子関係を示す）
function caf_render_start_category_field() {
    $categories = get_categories(array('hide_empty' => false, 'parent' => 0)); // すべての親カテゴリを取得
    $selected_category = get_option('caf_start_category', '');

    // 最初に「未選択」オプションを表示
    echo '<label>';
    echo '<input type="radio" name="caf_start_category" value="" ' . ($selected_category === '' ? 'checked' : '') . '>';
    echo '未選択(全カテゴリーを出力する)';
    echo '</label><br>';

    // 親カテゴリとその子カテゴリを表示
    function display_category_with_children_radio($parent_id = 0, $selected_category) {
        $categories = get_categories(array('hide_empty' => false, 'parent' => $parent_id));
        foreach ($categories as $category) {
            $checked = ($category->term_id == $selected_category) ? 'checked' : '';
            echo '<label style="margin-left: ' . ($parent_id ? '20px' : '0') . ';">';
            echo '<input type="radio" name="caf_start_category" value="' . esc_attr($category->term_id) . '" ' . $checked . '>';
            echo esc_html($category->name);
            echo '</label><br>';
            display_category_with_children_radio($category->term_id, $selected_category);
        }
    }

    display_category_with_children_radio(0, $selected_category);
}


function caf_render_column_width_field() {
    // 値を取得、値が空の場合はデフォルトで '25' を設定
    $current_value = get_option('caf_column_width', '25'); 
    ?>
    <label><input type="radio" name="caf_column_width" value="20" <?php checked($current_value, '20'); ?>> 5カラム(20%)</label><br>
    <label><input type="radio" name="caf_column_width" value="25" <?php checked($current_value, '25'); ?>> 4カラム(25%・標準)</label><br>
    <label><input type="radio" name="caf_column_width" value="33" <?php checked($current_value, '33'); ?>> 3カラム(33%)</label><br>
    <label><input type="radio" name="caf_column_width" value="50" <?php checked($current_value, '50'); ?>> 2カラム(50%)</label>
    <?php
}


function caf_column_width_section_callback() {
    echo '<p>ページタイトルに応じて、表示するカラムの幅を選択してください。</p>';
}


function caf_render_icon_field() {
    $current_value = get_option('caf_icon', 'default'); // デフォルトはデフォルトアイコン
    ?>
    <label><input type="radio" name="caf_icon" value="default" <?php checked($current_value, 'default'); ?>> デフォルトアイコン (標準)</label><br>
    <label><input type="radio" name="caf_icon" value="fontawesome" <?php checked($current_value, 'fontawesome'); ?>> Fontawesomeを使用</label>
    <?php
}

function caf_icon_section_callback() {
    echo '<p>アイコンの種類を選択してください。<br>※Fontawesomeが有効になっている場合のみ使用可能。</p>';
}

function caf_render_thumb_field() {
    $current_value = get_option('caf_icon', 'default'); // デフォルトはデフォルトアイコン
    ?>
    <label><input type="radio" name="caf_thumb" value="default" <?php checked($current_value, 'default'); ?>> 1.191 / 1 (標準)</label><br>
    <label><input type="radio" name="caf_thumb" value="aspect-4-3" <?php checked($current_value, 'aspect-4-3'); ?>> 4 / 3</label><br>
    <label><input type="radio" name="caf_thumb" value="aspect-16-9" <?php checked($current_value, 'aspect-16-9'); ?>> 16 / 9</label><br>
    <label><input type="radio" name="caf_thumb" value="aspect-1-1" <?php checked($current_value, 'aspect-1-1'); ?>> 1 / 1</label>
    <?php
}

function caf_thumb_section_callback() {
    echo '<p>アイキャッチ画像のアスペクト比率を選んでください。</p>';
}
?>
